clear
close all
clc
% Codice di simulazione con inseriti stallo, wind shear, drag da torre,
% variazione pitch. Pitch per ora costante sulla
% rivoluzione.
%% Dati input turbina - da variare se si voglino inserire altre macchine
Pnom = input('write hypotized nominal power in kW: ');
% studiato per 2 turbine: una da 200 kW a vento nominale di 12 m/s ed una
% da 6 MW a vento nominale di 11 m/s. Inserire dato di potenza nominale
% ottenuto da QBLADE. SE SI VOLESSE INSERIRE ALTRE TURBINE QUI VANNO
% MODIFICATE LE VOCI ED I DATI INSERITI NELL'IF SOTTOSTANTE.

if Pnom<400 && Pnom>150
    nometurb = 'u200';
    CL = load('clu200.dat'); CD = load('cdu200.dat');
    tc = 0.21;% rapporto spessore pala/corda (t/c) t/c = 0.21 per NACA0021,t/c = 0.24 per NACA0024
    finose = 61.35/180*pi;% leading edge angle del profilo, da polilinee profili.
    fitail = 13.08/180*pi;% trailing edge angle del profilo, da polilinee profili.
    zrif = 41; % altezza hub turbina
    Re = [1e6 2e6 4e6 8e6 1.6e7]; % valori Reynolds ipotizzati
    omega = 0:0.5:10;%rad/s
    dtower = 2.25; %m, diametro medio
    Cdcil = 1; % drag cilindro
elseif Pnom>5e3 && Pnom<8e3
    nometurb = 'tud6000';
    CL = load('cltud6000.dat'); CD = load('cdtud6000.dat');
    tc = 0.24;% rapporto spessore pala/corda (t/c) t/c = 0.21 per NACA0021,t/c = 0.24 per NACA0024
    finose = 71.73/180*pi;% leading edge angle del profilo, ottenuto da polilinee profili.
    fitail = 15.22/180*pi;% trailing edge angle del profilo, ottenuto da polilinee profili.
    zrif = 70; % altezza hub turbina
    Re = [4e6 8e6 1.6e7 3.5e7]; % valori Reynolds ipotizzati
    omega = 0:0.075:1.5;%rad/s
    dtower = 3.9; % m, diametro medio
    Cdcil = 1; % drag cilindro
else
    disp('wrong power value')
    return
end

ALFA = load('ALFA.dat');
aT = 0.4; % valore critico del coefficiente d'induzione
DATA = load(strcat('Data',nometurb,'.mat'));
np = DATA.Nominal.p; ll = DATA.Nominal.h;
Area = DATA.Nominal.A; alfa = ALFA/180*pi;
geom = load(strcat('blades',nometurb,'.mat'));% file con geometria della pala da QBLADE
ri = geom.geometry(:,1);% raggio medio pale alle sezioni considerate.
zi = geom.geometry(:,2);% Quota delle sezioni considerate.
delta = geom.geometry(:,3)/180*pi;% angolo medio della pala rispetto alla verticale nelle sezioni considerate
li = geom.geometry(:,4);% lunghezza pala nelle sezioni considerate.
ci = geom.geometry(:,5); % corda media nelle sezioni considerate.
ravg = sum(ri)/length(ri);
zv = zi/ll-0.5; % coordinate adimensionali su z
%% Angoli
dth = pi/50;
thm = -pi/2+dth/2:dth:pi/2-dth/2;
thv = pi-thm;

%% Dati da variare per cambiare lunghezza simulazione
Vwind = 1:1:25;
pthv = (0:1.5:18)*pi/180; % pitch

dens = 1.225; visc = 1.8e-5;
zr = 0.8; % roughness length. Media su area di svolgimento analisi di producibilità

%% SIMULAZIONE
toll = 0.0001;
MT = zeros(size(Vwind));
wott = MT;
%% Creation of aerodynamic force structures 
thetavect = [thm flip(thv)];

Tavg.V = Vwind; Tavg.pitch = pthv; Tavg.w = omega; % coppia media per controllo su coppia
Tavg.T = zeros(length(Tavg.w),length(Vwind),length(pthv));

Pavg.V = Vwind; Pavg.pitch = pthv; Pavg.w = omega; % potenza media per validazione codice
Pavg.P = zeros(length(Pavg.w),length(Vwind),length(pthv));

Ftblade.theta = thetavect'; Ftblade.V = Vwind; Ftblade.pitch = pthv; Ftblade.w = omega; % forza tangenziale sulla pala
Ftblade.Ft = zeros(length(Ftblade.w),length(thetavect),length(Vwind),length(pthv));

Fnblade.theta = thetavect'; Fnblade.V = Vwind; Fnblade.pitch = pthv; Fnblade.w = omega; % forza normale sulla pala
Fnblade.Fn = zeros(length(Fnblade.w),length(thetavect),length(Vwind),length(pthv));

Mzblade.theta = thetavect'; Mzblade.V = Vwind; Mzblade.pitch = pthv; Mzblade.w = omega; % momento torcente sulla pala
Mzblade.T = zeros(length(Mzblade.w),length(thetavect),length(Vwind),length(pthv));

lint = li(end);
%% DMST
Pp = zeros(size(pthv));
Cpv = zeros(size(Vwind));
Pv = zeros(size(Vwind));
% Composto da 5 cicli annidati:
% 1. Ciclo più interno calcola sollecitazioni sui singoli segmenti di pala
% lungo asse z dati azimut, pitch, velocità del vento e velocità angolare.
% Ogni angolo di azimut svolge i calcoli sulla parte a monte e sulla parte
% a valle della turbina.
% 2. Ciclo ripete 1 su tutti gli azimut, da 0 a 180°, dati pitch, velocità
% del vento e velocità angolare.
% 3. Ciclo ripete 2 su tutti gli angoli di pitch considerati (qui da 0° a
% 18°), dati velocità del vento e velocità angolari.
% 4. Ciclo ripete 3 per tutte le velocità angolari considerate. Scelte in
% modo da avere gamma di TSR attorno al punto di massima potenza a velocità
% del vento nominale. Svolto data la velocità del vento.
% 5. Ciclo ripete 4 per tutte le velocità del vento considerate.
% Possibile modificare valori di pitch, velocità angolare e velocità del
% vento per considerare casi specifici. Con i parametri inseriti adesso il
% programma a girare impiega circa 50'.
for v = 1:length(Vwind)
    Vin = Vwind(v);
    T = zeros(size(omega));
    Cp = zeros(size(omega));
    P = zeros(size(omega));
    for h = 1:length(omega)
        w = omega(h);
        Tang = zeros(size(thm)); Txz = Tang; Tup = Tang;
        Tdown = Tang; Ftvup = Tang; Ftvdown = Tang;
        Fnvup = Ftvup; Fnvdown = Fnvup;
        Mtvup = Tang; Mtvdown = Tang;
		Mnvup = Tang; Mnvdown = Tang;
        Mzup = Tang; Mzdown = Tang;
        Ctvup = Tang; Ctvdown = Tang;
        alfaupprec = pi/2*ones(size(ri));
        alfadownprec = -alfaupprec;
        aau = zeros(length(ri),length(thm));
        alfaup = zeros(length(ri),length(thm));
        alfadown = zeros(length(ri),length(thm));
        aavg = zeros(size(ri));
        Veq = zeros(size(ri));
        Tdv = zeros(size(ri));
        Tp = zeros(size(pthv));
        for kkk = 1:length(pthv)
            pth = pthv(kkk);
            for j = 1:length(thm)
                th1 = thm(j);
                th = thv(j);
                Txzi = zeros(size(ri)); Qa = Txzi;
                Qaup = Txzi; Qadown = Txzi;
                Ftup = Txzi; Ftdown = Txzi;
                Fnup = Txzi; Fndown = Txzi;
                Ctupz = Txzi; Ctdownz = Txzi;
                Taltup = Txzi; Taltdown = Txzi;% coppia
                for i = 1:length(ri)
                    % Wind shear
                    Vinf = Vin*log((zi(i)+zrif-ll/2)/zr)/log(zrif/zr);% calcolo velocità locale del vento
                    r = ri(i);
                    l = li(i);
                    dd = delta(i);
                    c = ci(i);
                    z = zv(i);
                    zcoord = zi(i);
                    a0 = 0;
                    err = 1;
                    it = 1;
                    % calcolo sollecitazioni per il lato a monte
                    while it<50 && err>toll
                        Vup = (1-a0)*Vinf;
                        X = r*w/Vup;
                        % Correzione per pale finite (Willmer-Prandtl)
                        s_tip = abs(pi*(1-2*a0)*Vinf/(np*w));
                        a_tip = 0.5*ll-abs(z*0.5*ll);
                        Fpr = acos(exp(-pi*a_tip/s_tip))/acos(exp(-pi*0.5*ll/s_tip));
                        if isnan(Fpr)
                            Fpr = 0;
                        end
                        Wup = Vup*sqrt((X -sin(th1))^2+Fpr^2*(cos(th1))^2*(cos(dd))^2);
                        if Fpr*cos(th1)*cos(dd)*Vup/Wup>1
                            fiup = pi/2;
                        else
                            fiup = asin(Fpr*cos(th1)*cos(dd)*Vup/Wup);% Angolo di vento relativo
                        end
                        aup = fiup-pth;
                        c = ci(i)*cos(pth);
                        acoeff = aup;
                        Reynolds = Wup*c*dens/visc;
                        del = Reynolds-Re;
                        index = find(min(del));
                        % Calcolo CL e CD con Reynolds variabile
                        CLv = CL(:,index);
                        CDv = CD(:,index);
                        Clup = interp1(alfa,CLv,acoeff);
                        Cdup = interp1(alfa,CDv,acoeff);
                        % Calcolo CL e CD con correzione per pale finite
                        as = 1.8*pi*(1+0.8*tc);
                        AR = ll/c;
                        Clup = Clup/(1+as/pi/AR);
                        Cdup = Cdup+Clup^2/pi/AR;
                        Cnup = (Clup * cos(aup) + Cdup * sin(aup));
                        Ctup = (Clup * sin(aup) - Cdup * cos(aup));
                        % Calcolo CM
                        rnc = 0.07; % rnose/c misurato da profili usati
                        xcp = 0.5-0.35*(fitail*(0.2+0.08*fitail)+(0.3-finose*(0.2+0.08*finose))*(1-1.8*sqrt(rnc)-0.3));
                        Cmup = -Cnup*(xcp-0.16*(1-2*abs(aup)/pi)-0.25);
                        % Calcolo fattore d'induzione
                        Fx = np*c/(8*pi*r)*(Wup/Vinf)^2*(Cnup*cos(th1)+Ctup*sin(th1)/cos(dd));
                        a = Fx+a0^2;
                        if a<aT
                            CThr = 4*a*(1-a);
                        else
                            CThr = 0.889-((0.0203-(a-0.143)^2)/0.6427);
                        end
                        if (CThr>0.96*Fpr)
                            a = 18*Fpr-20-3*sqrt(abs(CThr*(50-36*Fpr)+12*Fpr*(3*Fpr-4)))/(36*Fpr-50); end
                        if a<=0
                            a = 0.01;
                        end
                        if a>=1
                            a = 0.99;
                        end
                        err = abs(a0-a);
                        % Aggiornamento indici
                        a0 = a;
                        it = it+1;
                    end
                    aau(i,j) = a;
                    alfaup(i,j) = acoeff;
                    au = a;
                    a0 = au; % k = 1-a
                    err = 1;
                    it = 1;
                    % calcolo sollecitazioni per il lato a monte
                    while it<50 && err>toll
                        Vdown = (1-a0)*(1-2*au)*Vinf;
                        % Controllo per non avere in ingresso velocità
                        % negative
                        if Vdown<=0
                            Vdown = 0.01; end
                        X = r*w/Vdown;
                        % Correzione per pale finite (Willmer-Prandtl)
                        s_tip = abs(pi*(1-2*a0)*(1-2*au)*Vinf/(np*w));
                        a_tip = 0.5*ll - abs(z*0.5*ll);
                        Fpr = acos(exp(-pi*a_tip/s_tip))/acos(exp(-pi*0.5*ll/s_tip));
                        if isnan(Fpr)
                            Fpr = 0;
                        end
                        Wdown = Vdown*sqrt(Fpr^2*(cos(th)*cos(dd))^2+(X-sin(th))^2);
                        if Fpr*cos(th)*cos(dd)*Vdown/Wdown>1
                            fidown = pi/2;
                        else
                            fidown = asin(Fpr*cos(th)*cos(dd)*Vdown/Wdown);
                        end
                        adown = fidown+pth;
                        c = ci(i)*cos(pth);
                        acoeff = adown;
                        Reynolds = Wdown*c*dens/visc;
                        del = Reynolds-Re;
                        index = find(min(del));
                        % Calcolo CL e CD con vento variabile
                        CLv = CL(:,index);
                        CDv = CD(:,index);
                        Cldown = interp1(alfa,CLv,acoeff);
                        Cddown = interp1(alfa,CDv,acoeff);
                        % Calcolo CL e CD con correzione pale finite
                        as = 1.8*pi*(1+0.8*tc);
                        AR = ll/c;
                        Cldown = Cldown/(1 + as/(pi*AR));
                        CDi = Cldown^2/(pi*AR);
                        Cddown = Cddown + CDi;
                        Cndown = (Cldown*cos(adown)+Cddown*sin(adown));
                        Ctdown = (Cldown*sin(adown)-Cddown*cos(adown));
                        % Calcolo CM
                        rnc = 0.07; % rnose/c misurato
                        xcp = 0.5-0.35*(fitail*(0.2+0.08*fitail)+(0.3-finose*(0.2+0.08*finose))*(1-1.8*sqrt(rnc)-0.3));
                        Cmdown = -Cndown*(xcp-0.16*(1-2*abs(adown)/pi)-0.25);
                        % Calcolo fattore d'induzione
                        Fx = np*c/(8*pi*r)*(Wdown/Vinf/(1-2*au))^2*...
                            (Cndown*cos(th)+Ctdown*sin(th)/cos(dd));
                        a = a0^2+Fx;
                        if a<aT
                            CThr = 4*a*(1-a);
                        else
                            CThr = 0.889-((0.0203-(a-0.143)^2)/0.6427);
                        end
                        if (CThr>0.96*Fpr)
                            a = 18*Fpr-20-3*sqrt(abs(CThr*(50-36*Fpr)+12*Fpr*(3*Fpr-4)))/(36*Fpr-50); end
                        if a>=1
                            a = 0.99;
                        end
                        if a<=0
                            a = 0.01;
                        end
                        err = abs(a0-a);
                        a0 = a;
                        it = it+1;
                    end
					[Ctupz(i),Ftup(i),Fnup(i),Taltup(i),Ctdownz(i),...
                        Ftdown(i),Fndown(i),Taltdown(i)] = forces(c,...
                        dens,Clup,Cdup,Cmup, Wup,dd,Cldown,Cddown,...
                        Cmdown,Wdown,fiup,fidown);
                    alfadown(i,j) = acoeff;
                    z = z+li(i)/ll;
                end
                Tang(j) = lint*trapz(Qa);
                Txz(j) = lint*trapz(Txzi);
                Mzup(j) = lint*trapz(Taltup);
                Mzdown(j) = lint*trapz(Taltdown);
                Ftvup(j) = lint*trapz(Ftup);
                Fnvup(j) = lint*trapz(Fnup);
                Ftvdown(j) = lint*trapz(Ftdown);
                Fnvdown(j) = lint*trapz(Fndown);
                Ctvup(j) = 1/length(ri)*sum(Ctupz);
                Ctvdown(j) = 1/length(ri)*sum(Ctdownz);
            end
            %% Calcolo drag della torre
            for i =1:length(ri)
                aavg(i) = mean(aau(i,:),'omitnan'); % imposto coefficiente di induzione medio sulla circonferenza
                Vinf = Vin*log((zi(i)+zrif-ll/2)/zr)/log(zrif/zr);
                Veq(i) = (1-2*aavg(i))*Vinf;
                Tdv(i) = 0.5*Cdcil*dens*dtower*dtower/2*ll/length(li)*Veq(i)^2;
            end
            Td = sum(Tdv);
            Ftv = [Ftvup flip(Ftvdown)];
            Fnv = [Fnvup flip(Fnvdown)];
            Mtv = [Mtvup flip(Mtvdown)];
			Mnv = [Mnvup flip(Mnvdown)];
            Tv = [Tup flip(Tdown)];
            Mzv = [Mzup flip(Mzdown)];
            Tblade.T(h,:,v,kkk) = Tv;
            Ftblade.Ft(h,:,v,kkk) = Ftv;
            Ctv = [Ctvup flip(Ctvdown)];
            Fnblade.Fn(h,:,v,kkk) = Fnv;
            Mtblade.Mt(h,:,v,kkk) = Mtv;
			Mnblade.Mn(h,:,v,kkk) = Mnv;
            Mzblade.T(h,:,v,kkk) = Mzv;
            Tp(kkk) = np*ravg*trapz(dth,Ftv)/2/pi-Td;
            Tavg.T(h,v,kkk) = Tp(kkk);
            Pavg.P(h,v,kkk) = Tp(kkk)*w;
            Cp(h) = P(h)/(0.5*dens*Area*Vin^3);
        end
    end
    % Calcoli di verifica della potenza
    Pv(v) = max(T)*w;
    Cpv(v) = mean(Cp);
    MP = max(P);
    ind = 1;
    for mm = 1:length(P)
        if P(mm) == MP
            ind = mm;
        end 
    end
    Cpmax = max(Cp);
    med = find(max(Cp));
    wott(v) = omega(ind);
    MT(v) = T(ind);
end
%% Salvataggio strutture dati 
save(strcat('Ft',nometurb,'.mat'),'-struct','Ftblade');
save(strcat('Fn',nometurb,'.mat'),'-struct','Fnblade');
save(strcat('Mz',nometurb,'.mat'),'-struct','Mzblade');
save(strcat('Tavg',nometurb,'.mat'),'-struct','Tavg');